using System;
using System.Collections.Generic;
namespace bakiisrecko
{
    class Program
    {
        struct Vektor
        {
            public long x;
            public long y;
            public int index;
            public long Euklid(long x, long y)
                {
                    return x*x + y*y;
                }
        }
        static void Main()
        {
            int N = int.Parse(Console.ReadLine());
            List<Vektor> vektori = new List<Vektor>();
            for (int i = 1; i <= N; i++)
            {
                string[] unos = Console.ReadLine().Split();
                long x = long.Parse(unos[0]);
                long y = long.Parse(unos[1]);
                if (x != 0 || y != 0)
                {
                    vektori.Add(new Vektor { x = x, y = y , index = i });
                }
            }
            vektori.Sort((a, b) => (b.Euklid(b.x,b.y)).CompareTo(a.Euklid(a.x,a.y)));
            long pomX = 0;
            long pomY = 0;
            List<int> max = new List<int>();
            foreach (var v in vektori)
            {
                if (v.x * pomX + v.y * pomY >= 0)
                {
                    pomX += v.x;
                    pomY += v.y;
                    max.Add(v.index);
                }
            }
            Console.WriteLine(max.Count);
            if (max.Count > 0)
            {
                max.Sort();
                Console.WriteLine(string.Join(" ",max));
            }
        }
    }
}